/**
 * \file parameters.h
 * \brief Parameters of the MIRATH scheme
 */

#ifndef MIRATH_PARAMETER_H
#define MIRATH_PARAMETER_H

#include "mirath_param_128b.h"

#define DOMAIN_SEPARATOR_MESSAGE 0
#define DOMAIN_SEPARATOR_HASH1 1
#define DOMAIN_SEPARATOR_HASH2_PARTIAL 2
#define DOMAIN_SEPARATOR_HASH2 3
#define DOMAIN_SEPARATOR_TREE 4
#define DOMAIN_SEPARATOR_COMMITMENT 5

#define MIRATH_VAR_GAMMA (MIRATH_PARAM_RHO * (MIRATH_PARAM_M * MIRATH_PARAM_N - MIRATH_PARAM_K))
#define MIRATH_VAR_S (MIRATH_PARAM_M * MIRATH_PARAM_R)
#define MIRATH_VAR_C (MIRATH_PARAM_R * (MIRATH_PARAM_N - MIRATH_PARAM_R))
#define MIRATH_VAR_BASE_MID (MIRATH_PARAM_M * (MIRATH_PARAM_N - MIRATH_PARAM_R))
#define MIRATH_VAR_E_A (MIRATH_PARAM_M * MIRATH_PARAM_N - MIRATH_PARAM_K)
#define MIRATH_VAR_T (MIRATH_PARAM_M * MIRATH_PARAM_N)

#endif

