
#ifndef MIRATH_TCITH_DATA_TYPES_H
#define MIRATH_TCITH_DATA_TYPES_H

#include <stdint.h>
#include "mirath_parameters.h"

typedef uint8_t seed_t[MIRATH_SECURITY_BYTES];
typedef uint8_t hash_t[2 * MIRATH_SECURITY_BYTES];

typedef uint8_t mirath_tcith_commit_t[2 * MIRATH_SECURITY_BYTES];
typedef uint32_t mirath_tcith_view_challenge_t[MIRATH_PARAM_TAU];

#define MIRATH_BLOCK_LENGTH ((MIRATH_VAR_FF_S_BYTES + MIRATH_VAR_FF_C_BYTES + (MIRATH_PARAM_RHO * sizeof(ff_mu_t)) + (MIRATH_SECURITY_BYTES - 1)) / MIRATH_SECURITY_BYTES)

#define DOMAIN_SEPARATOR_MESSAGE 0
#define DOMAIN_SEPARATOR_HASH1 1
#define DOMAIN_SEPARATOR_HASH2_PARTIAL 2
#define DOMAIN_SEPARATOR_HASH2 3
#define DOMAIN_SEPARATOR_TREE 4
#define DOMAIN_SEPARATOR_COMMITMENT 5

#define MIRATH_VAR_GAMMA (MIRATH_PARAM_RHO * (MIRATH_PARAM_M * MIRATH_PARAM_N - MIRATH_PARAM_K))
#define MIRATH_VAR_S (MIRATH_PARAM_M * MIRATH_PARAM_R)
#define MIRATH_VAR_C (MIRATH_PARAM_R * (MIRATH_PARAM_N - MIRATH_PARAM_R))
#define MIRATH_VAR_BASE_MID (MIRATH_PARAM_M * (MIRATH_PARAM_N - MIRATH_PARAM_R))
#define MIRATH_VAR_E_A (MIRATH_PARAM_M * MIRATH_PARAM_N - MIRATH_PARAM_K)
#define MIRATH_VAR_T (MIRATH_PARAM_M * MIRATH_PARAM_N)

#endif //MIRATH_TCITH_DATA_TYPES_H
